-- Überstunden- und Mindestpausenberechnung
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln
CREATE OR REPLACE FUNCTION bdep__a_iu() RETURNS TRIGGER AS $$
  DECLARE
      bdsaldo             numeric(12,4);  -- Summe Einzelstempelungen Saldo (netto, bereits OHNE Pausen) > Wiki
      f3                  numeric(12,4);
      gpause              numeric(12,4);  -- Gesamt genommene Pause am Tag: Summe aus direkten Abzug in Einzelstempelung (bdep) zzgl. der Abwesendzeiten
      last_bd_end         timestamp(0) without time zone;
      r                   record;
      ueberrund           numeric(12,4);
      uebschwelle         numeric(12,4);
      uebermin            numeric(12,4);
      tplanminpause       numeric(12,4);  -- Mindestpause gem. Tagesplan
      minPausenAbzug      numeric(12,4);  -- Zusätzlicher Pausenabzug, da Mindestpausen nicht eingehalten wurden.
      tplmin              numeric(12,4);
      ueberfrac           numeric(12,4);
      tplanname           varchar;
      bdab_stu_gutschrift numeric;
      -- Settings
      bdepab_minpause__max_saldo_ueber_sollzeit boolean;  -- 'BDE.bdepab_minpause__max_saldo_ueber_sollzeit' (versteckt)
      BDEP_tpl_uebstund_Unterzeit_Runden        boolean;  -- 'BDEP.tpl_uebstund.Unterzeit.Runden'
  BEGIN
    IF current_user = 'syncro' OR new.bd_buch THEN RETURN new; END IF; -- Änderungen verwerfen. Das ist bereits verbucht.

    IF tg_op = 'UPDATE' THEN
        -- Hier ändert sich etwas an der Pause, die Folgestempelungen müssen neu berechnet werden.
        IF old.bd_restpause <> new.bd_restpause THEN
            UPDATE bdep SET
              bd_gleitpause = NULL,
              bd_blockpause = NULL
            WHERE bd_id = (
                SELECT bd_id
                FROM bdep
                WHERE bd_minr = new.bd_minr
                  AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
                  AND bd_anf > new.bd_anf
                ORDER BY bd_anf LIMIT 1
                )
            ;
        END IF;
    END IF;

    -- Initial: alte Mindestpausen weg, Stammdaten aus Tagesplan, Überstunden, Überstundenschwelle, Rundung usw.
        -- Alte Mindestpause löschen.
        DELETE FROM bdepab
        WHERE bdab_aus_id = 101 -- Abwesenheitsgrund Mindestpause!!
          AND bdab_minr = new.bd_minr
          AND new.bd_individwt_mpl_date BETWEEN bdab_anf AND bdab_end
        ;

        -- Tagesplan-Daten
        tplanname := mpl_tpl_name FROM mitpln WHERE mpl_date = new.bd_individwt_mpl_date AND mpl_minr = new.bd_minr;

        SELECT  tpl_minpause,  tpl_uebstund, tpl_uebstundab / 60,  tpl_min
        INTO    tplanminpause, ueberrund,    uebschwelle,          tplmin
        FROM tplan
        WHERE tpl_name = tplanname;


        -- Settings
          -- Mindestpause: Maximal der Präsenzzeit-Anteil über Arbeitszeit-Grenze für globale Mindestpause, siehe #11814.
          -- Die Mindestpause wird anteilig und erst mit Überschreiten der Arbeitszeit-Grenze (globale Mindestpause) abgezogen. Der Anteil ist dabei maximal die Zeit über der Arbeitszeit-Grenze.
          -- Bsp: ab 6 h Präsenzzeit 0:30 h Soll-Pause, 6:10 Präsenzzeit = 0:10 h Abzug durch autom. Mindestpause.
          -- zus. Bedingung: Eintrag in TP-Mindestpause muss NULL sein.
          bdepab_minpause__max_saldo_ueber_sollzeit := TSystem.Settings__GetBool('BDE.bdepab_minpause__max_saldo_ueber_sollzeit', true); -- #11814, hidden setting, default true

          -- Setting 1: Überzeit UND Unterzeit anhand Überzeitrundung des Tagesplans runden.
          -- Setting 0: Überzeitrundung nur bei Überzeit. Wenn Unterzeit, dann normal anhand Tagesplan-Rundung.
          BDEP_tpl_uebstund_Unterzeit_Runden := TSystem.Settings__GetBool('BDEP.tpl_uebstund.Unterzeit.Runden');
        --

        -- Variablen initialisieren
        gpause := 0; minPausenAbzug := 0; last_bd_end := NULL;
    --

    -- Pausen: Pausen in Stempelzeiten SOWIE alle Zwischenzeiten (Zeiten in denen der Arbeitnehmer ausgestempelt hatte) als Pause zusammenziehen.
    SELECT  sum(bd_saldo),  sum( coalesce(bd_gleitpause, 0) + coalesce(bd_blockpause, 0) )
    INTO    bdsaldo,        gpause
    FROM bdep
    WHERE bd_minr = new.bd_minr
      AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
      AND bd_end IS NOT NULL;

    -- eingetragene Abwesenheiten "Pause" anrechnen.
    gpause :=
        gpause
        + coalesce(
            ( SELECT sum(abs(bdab_stu))
              FROM bdepab
              WHERE bdab_minr = new.bd_minr
                AND bdab_anf = new.bd_individwt_mpl_date
                AND bdab_stu < 0
                AND bdab_aus_id = 110
            )
            , 0
          )
    ;

    -- Pausen errechnen: Pausen durch ausgestempelte Zeiten
    -- Achtung derzeit OHNE Flag. Man könnte hier nur die Zeiten zählen, welche auch als Pause abgestempelt wurden (z.B. ausschließen Dienstwege?!).
    FOR r IN
        SELECT bd_anf_rund, bd_end_rund, bd_aus_id, bd_id
        FROM bdep
        WHERE bd_minr = new.bd_minr
          AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
        ORDER BY bd_anf_rund, bd_id
    LOOP
        IF last_bd_end IS NOT NULL -- wir hatten schon eine Stempelung
          -- Fall Dienstgang durch MA gestempelt, soll nicht als Pause gewertet werden; neu in #19377
          -- weiter unten wird das manuelle Eintragen geprüft, also Eintrag durch Personaler, ohne Stemplung des MA
          AND ( NOT EXISTS(SELECT true FROM bdepab
                             WHERE
                               bdab_minr = new.bd_minr
                               AND ( bdab_bd_id_anf = new.bd_id    -- Abstempeln mit Dienstgang
                                     OR bdab_bd_id_end = new.bd_id -- Erneutes Anstempeln beendet Dienstgang
                                   ) -- Prüfung des Abwesenheitsgrunds implizit über bdab_bd_id_anf, da trigger bdep__a_u Feld bdab_bd_id_anf nur setzt
                                     -- im Falle bdeabgruende__Gutschrift_Is, also Abwesenheit mit positiver Gutschrift
                          )
          )
          THEN
            gpause := gpause + timediff(last_bd_end, r.bd_anf_rund); -- Das ist eine Pause, die der Mitarbeiter gestempelt hatte.

            IF current_user = 'root' THEN -- Debug
                RAISE NOTICE '3: last_bd_end = %; bd_anf = %; diff = %; gpause = %', last_bd_end, r.bd_anf_rund, timediff(last_bd_end, r.bd_anf_rund), gpause;
            END IF;
        END IF;

        last_bd_end := r.bd_end_rund; -- zwischenzeitliche Abstempelungen zählen als Pause.
    END LOOP;

    -- Fall Dienstgang manuell nachgetragen -- neu in #19377
    bdab_stu_gutschrift :=  (SELECT bdab_stu FROM bdepab
                               WHERE bdab_anf = new.bd_individwt_mpl_date AND bdab_end = new.bd_individwt_mpl_date --nur genau dieser tag
                                 AND bdab_minr = new.bd_minr
                                 AND bdab_bd_id_anf IS NULL --nicht durch Mitarbeiter gestemeplet
                                 AND bdeabgruende__Gutschrift_Is(bdab_aus_id) AND bdab_stu > 0
                            ); --es handelt sich um Dienstgang mit positiver Gutschrift

    IF bdab_stu_gutschrift IS NOT NULL THEN -- Fall Dienstgang manuell nachgetragen, wenn diese Bedingung erfüllt
        gpause := gpause - bdab_stu_gutschrift;
    END IF;

    -- gpause hält jetzt die Summe aller Pausen: gestempelte Pausen durch Abwesenheiten sowie vom System an der Stempelung abgezogene Pausen.

    -- Mindestpausen eingehalten? > https://redmine.prodat-sql.de/issues/17018
        -- Prüfen, ob die Summe der genommenen Pausen in Kombination mit der Arbeitszeit für Mindestpausen ausreichend ist.

        -- 1. Prüfung auf Mindestpause gemäß Tagesplan
        IF current_user = 'root' THEN -- Debug
            RAISE NOTICE 'tplanminpause = % gpause = % minPausenAbzug = % tplanminpause > gpause = %', tplanminpause, gpause, minPausenAbzug, tplanminpause > gpause;
        END IF;

        IF tplanminpause IS NOT NULL AND tplanminpause > gpause THEN -- Wenn mehr Pause hätte genommen werden müssen (gemäß Tagesplan).
            -- Ermittlung der Pause, die noch genommen hätte werden müssen.
            -- Keine Rundung anhand Überzeitrundung (ueberrund), sondern bloß auf 4 NK genau.
            minPausenAbzug := tplanminpause - gpause;

            IF current_user = 'root' THEN -- Debug
                RAISE NOTICE '"tplanminpause > gpause" minPausenAbzug: % tplanminpause: % gpause: %', minPausenAbzug, tplanminpause, gpause;
            END IF;
        END IF;

        -- Mindestpause einhalten, wenn Arbeitszeit größer als X.
        -- Durchläuft die Mindestpause von unten nach oben und zieht immer jeweils ab.
        FOR r IN
            SELECT mp_arbstu, mp_minpause
            FROM minpause
            WHERE mp_arbstu < bdsaldo
            ORDER BY mp_arbstu
        LOOP
            -- Trotz Arbeitszeit-Minus, der noch zu nehmenden Pause (laut Tagesplan), ist Grenzwert der Arbeitszeit für globale Mindestpause überschritten.
            IF r.mp_arbstu < bdsaldo - minPausenAbzug THEN

                IF current_user = 'root' THEN -- Debug
                    RAISE NOTICE 'r.mp_arbstu = %, bdsaldo = % (-minPausenAbzug); r.mp_minpause = % gpause = % minPausenAbzug = % r.mp_minpause > gpause + minPausenAbzug = %, r.mp_minpause - gpause - minPausenAbzug = %'
                                , r.mp_arbstu,     bdsaldo,                       r.mp_minpause,    gpause,    minPausenAbzug,    r.mp_minpause > gpause + minPausenAbzug,     r.mp_minpause - gpause - minPausenAbzug;
                END IF;

                -- Mindestpause bei der angegebenen Arbeitszeit nicht eingehalten.
                IF r.mp_minpause > gpause + minPausenAbzug THEN

                    -- Ermittlung der Pause, die noch genommen hätte werden müssen.
                    IF bdepab_minpause__max_saldo_ueber_sollzeit THEN -- siehe oben und #11814

                        -- Eintrag Tagesplan-Mindestpause wird bevorzugt (0 = keine Pause laut TP).
                        IF tplanminpause IS NULL THEN
                            -- Maximal abziehen: Arbeitszeit über Grenzwert der Arbeitszeit für globale Mindestpause (9 h Grenze, 45 min globale Mindestpause, 15 min gestempelte Pause bzw. feste Pausen, 9:10 h Arbeitszeit = 10 min).
                            -- GREATEST: Grenzwert der Arbeitszeit muss erst erreicht werden, bevor globale Mindestpause abgezogen wird.
                            -- Obergrenze ist globale Mindestpause abzgl. bereits gestempelter Pause (9:31 h Arbeitszeit (und mehr) = 45 - 15 = 30 min).
                            minPausenAbzug := LEAST(GREATEST(bdsaldo - r.mp_arbstu, 0), r.mp_minpause - gpause);
                        END IF;
                    ELSE
                        minPausenAbzug := r.mp_minpause - gpause; -- Pause komplett abziehen (altes Verhalten vor #11814)
                    END IF;

                    IF current_user = 'root' THEN -- Debug
                        RAISE NOTICE '"r.mp_minpause > gpause + minPausenAbzug" minPausenAbzug: % r.mp_minpause: % gpause: %', minPausenAbzug, r.mp_minpause, gpause;
                    END IF;
                END IF;
            END IF;
        END LOOP;
    -- Mindestpause

    -- Eintragen der zusätzlichen Mindestpause in bdepab.
    IF minPausenAbzug > 0 THEN
        -- Wenn kein Tagesplan hinterlegt ist, dann keine globale Mindestpause einfügen. #6785
        IF tplanname IS NOT NULL THEN
            -- Mindestpause eintragen in Form von Abzug.
            INSERT INTO bdepab  (bdab_anf,                bdab_end,                 bdab_minr,    bdab_aus_id,  bdab_stu)
            VALUES              (new.bd_individwt_mpl_date, new.bd_individwt_mpl_date,  new.bd_minr,  101,          - minPausenAbzug);
        ELSE
            minPausenAbzug := 0; -- In Zusammenhang mit #6785 betrachten. Wenn kein Eintrag der Mindespause, darf keine Mindestpause in mpl_saldo addiert werden, s.u..
        END IF;
    END IF;

    -- Überzeitrundung. Hier muss klar sein, wieviel Mindestpause nach (Brutto) Arbeitszeit abgezogen wird,
    -- da ja die Überstunde entsprechend erst gar nicht zählen, wenn sie vorher durch Mindestpause wieder (teilweise) aufgehoben werden.

    -- kein Tagesplan, dann minutengenaue Arbeitszeit
    IF tplanname IS NULL THEN
        bdsaldo := round(bdsaldo * 60) / 60;
    ELSE
        -- mindestens minutengenau
        ueberrund := GREATEST(ueberrund, 1);

        -- Arbeitszeit (bdsaldo) ohne restliche Mindestpause (Tagesplan-Mindestpause ohne gestempelte Pausen). Negative Restpause erzeugt keine Arbeitszeit, mindestens 0.
        -- Diese echte, minutengenaue Arbeitszeit wird anhand Überzeitrundung abgerundet.
        -- Mindestpause wird nicht anhand Überzeitrundung gerundet, sondern minutengenau erfasst.
        bdsaldo := bdsaldo - GREATEST(minPausenAbzug, 0);

        -- Neue Berechnung des ganze Blocks (Beachte allerdings Änderung: Unterzeit keine Rundung anhand Überzeitrundung)
          -- arbeitszeit := f4;
          -- arbeitszeit := arbeitszeit - (((((arbeitszeit - tplmin) * 60) % ueberrund) + ueberrund) % ueberrund) / 60;

        ueberfrac := bdsaldo - tplmin - trunc(bdsaldo - tplmin);

        IF current_user = 'root' THEN -- Debug
            RAISE NOTICE 'bdsaldo: %; ueberfrac: %', bdsaldo, ueberfrac;
        END IF;

        -- Jetzt eigentliche Überstundenberechnung
        IF     BDEP_tpl_uebstund_Unterzeit_Runden -- Setting, s.o.
            OR (  -- eigentliche Überstundenberechnung
                  (ueberfrac >= 0)
              AND (bdsaldo - tplmin >= 0)
            )
        THEN
            IF ( ( ( (ueberfrac * 60)::INTEGER ) % ueberrund ) <> 0 ) THEN -- AND NOT (Round(ueberfrac * 60) % ueberrund = 0)
                uebermin := ueberfrac * 60; -- Nun haben wir die Überminuten!
                f3 := uebermin;

                IF current_user = 'root' THEN -- Debug
                    RAISE NOTICE 'uebermin: %', uebermin;
                END IF;

                uebermin := uebermin::INTEGER / ueberrund::INTEGER * ueberrund; -- Damit haben wir abgerundet die bewilligte Überzeit / mit Integer ergibt DIV.
                IF current_user = 'root' THEN -- Debug
                    RAISE NOTICE 'uebermin1: %', uebermin;
                END IF;

                -- Stundenanteile dazurechnen
                f3 := trunc(bdsaldo - tplmin); -- Überstunden stunden

                -- Setting 1: Überzeit UND Unterzeit anhand Überzeitrundung des Tagesplans runden.
                -- UND wir haben Unterzeit, dann aufrunden und nicht abrunden der Zeiten.
                IF BDEP_tpl_uebstund_Unterzeit_Runden AND ((uebermin < 0) OR (bdsaldo - tplmin < 0)) THEN
                    uebermin := uebermin - ueberrund;
                END IF;

                -- nun zurückschreiben
                bdsaldo := tplmin + uebermin / 60 + f3; -- Das ist die gerundete Überzeit (ergeben aus Sollzeit Tagesplan und gerundeten Überstunden).
            END IF;
        END IF;
    END IF;

    -- Wir schreiben die neuen Stunden in den Tagesplan auf.
    IF current_user = 'root' THEN -- Debug
        RAISE NOTICE 'bdsaldo_rund: % uebschwelle: % tplmin: % minPausenAbzug: %', bdsaldo, uebschwelle, tplmin, minPausenAbzug;
        RAISE NOTICE 'bdsaldo - tplmin: %', bdsaldo - tplmin;
    END IF;

    -- Mindestüberstunden eingehalten
    IF      (coalesce(uebschwelle, 0) > 0)
        AND (bdsaldo - tplmin > 0)
        AND (bdsaldo - tplmin < uebschwelle)
    THEN
        bdsaldo := tplmin;
       -- Wir haben zwar Überzeit, aber zu wenig = nicht anerkannt. => wir setzen das Saldo einfach per Hand auf die Vorgabe.
       -- Pausenabzu dazu addieren: Vorgabe ist 8 Stunden, ich arbeite 8,75; Ueberstundenschwelle = 0,5. Mindestpause = 0,5.
       -- Die Mindestpause wird vom System eingetragen, wenn der MAB nicht stempelt.
    END IF;

    -- Übertragung Ergebnis in mitpln
    UPDATE mitpln SET
      mpl_saldo = bdsaldo + coalesce(minPausenAbzug, 0)
    WHERE mpl_minr = new.bd_minr
      AND mpl_date = new.bd_individwt_mpl_date
    ;

    RETURN new;
  END $$ LANGUAGE plpgsql;